# Uzbek (uz) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                 | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ----------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                            | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                               | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                            | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                               | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | CH.1                                            | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | CH.2                                            | Invalid Date             |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1-chi chorak                                    | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-chi chorak                                    | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                               | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                               | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | CH.1                                            | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | CH.2                                            | Invalid Date             |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1-chi chorak                                    | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-chi chorak                                    | Invalid Date             |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                               | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | Fev                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Iyul                                            | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | Fevral                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Iyul                                            | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | F                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | I                                               | Invalid Date             |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                               | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | Fev                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Iyul                                            | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | Fevral                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Iyul                                            | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | F                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | I                                               | Invalid Date             |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                               | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                              | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                               | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                              | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                              | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                             | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | Dush                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Jum                                             | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | Dush                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Jum                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | Dush                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Jum                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | Dushanba                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Juma                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | D                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | J                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | Du                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ju                                              | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                               | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | Dush                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Jum                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | Dushanba                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Juma                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | D                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | J                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | Du                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ju                                              | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                               | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | Dush                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Jum                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | Dushanba                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Juma                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | D                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | J                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | Du                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ju                                              | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                               | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | Dush                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Jum                                             | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | Dushanba                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Juma                                            | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | D                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | J                                               | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | Du                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ju                                              | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | am                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | a.m.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                               | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | am                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | a.m.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                               | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | ertalab                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | tushdan keyin                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | kechqurun                                       | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | tun                                             | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | ertalab                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | tushdan keyin                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | kechqurun                                       | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | tun                                             | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | ertalab                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | tushdan keyin                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | kechqurun                                       | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | tun                                             | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | ertalab                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | tushdan keyin                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | kechqurun                                       | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | tun                                             | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | ertalab                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | tushdan keyin                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | kechqurun                                       | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | tun                                             | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                              | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                              | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                              | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                              | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                              | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                               | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                              | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                               | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                              | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/02/1987                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                      | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 Fev, 1987                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 May, 1453                                    | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 Fevral, 1987                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 May, 1453                                    | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | Chorshanba, 11 Fevral, 1987                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | Yakshanba, 29 May, 1453                         | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                           | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59                                           | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                        | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59                                        | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 GMT+0                                  | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 GMT+00:00                              | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13                               | 1987-02-11T00:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 11:59                               | 1453-05-29T11:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 Fev, 1987, 12:13:14                          | 1987-02-11T00:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 May, 1453, 11:59:59                          | 1453-05-29T11:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 Fevral, 1987, 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 May, 1453, 11:59:59 GMT+0                    | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | Chorshanba, 11 Fevral, 1987, 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | Yakshanba, 29 May, 1453, 11:59:59 GMT+00:00     | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result           | `includeSeconds: true` | `addSuffix: true`          |
| ------------------------ | ---------------- | ---------------------- | -------------------------- |
| 2006-01-01T00:00:00.000Z | tahminan 6 yil   | tahminan 6 yil         | tahminan 6 yil dan keyin   |
| 2005-01-01T00:00:00.000Z | tahminan 5 yil   | tahminan 5 yil         | tahminan 5 yil dan keyin   |
| 2004-01-01T00:00:00.000Z | tahminan 4 yil   | tahminan 4 yil         | tahminan 4 yil dan keyin   |
| 2003-01-01T00:00:00.000Z | tahminan 3 yil   | tahminan 3 yil         | tahminan 3 yil dan keyin   |
| 2002-01-01T00:00:00.000Z | tahminan 2 yil   | tahminan 2 yil         | tahminan 2 yil dan keyin   |
| 2001-06-01T00:00:00.000Z | 1 yildan ko'p    | 1 yildan ko'p          | 1 yildan ko'p dan keyin    |
| 2001-02-01T00:00:00.000Z | tahminan 1 yil   | tahminan 1 yil         | tahminan 1 yil dan keyin   |
| 2001-01-01T00:00:00.000Z | tahminan 1 yil   | tahminan 1 yil         | tahminan 1 yil dan keyin   |
| 2000-06-01T00:00:00.000Z | 5 oy             | 5 oy                   | 5 oy dan keyin             |
| 2000-03-01T00:00:00.000Z | 2 oy             | 2 oy                   | 2 oy dan keyin             |
| 2000-02-01T00:00:00.000Z | tahminan 1 oy    | tahminan 1 oy          | tahminan 1 oy dan keyin    |
| 2000-01-15T00:00:00.000Z | 14 kun           | 14 kun                 | 14 kun dan keyin           |
| 2000-01-02T00:00:00.000Z | 1 kun            | 1 kun                  | 1 kun dan keyin            |
| 2000-01-01T06:00:00.000Z | tahminan 6 soat  | tahminan 6 soat        | tahminan 6 soat dan keyin  |
| 2000-01-01T01:00:00.000Z | tahminan 1 soat  | tahminan 1 soat        | tahminan 1 soat dan keyin  |
| 2000-01-01T00:45:00.000Z | tahminan 1 soat  | tahminan 1 soat        | tahminan 1 soat dan keyin  |
| 2000-01-01T00:30:00.000Z | 30 minut         | 30 minut               | 30 minut dan keyin         |
| 2000-01-01T00:15:00.000Z | 15 minut         | 15 minut               | 15 minut dan keyin         |
| 2000-01-01T00:01:00.000Z | 1 minut          | 1 minut                | 1 minut dan keyin          |
| 2000-01-01T00:00:25.000Z | bir minutdan kam | yarim minut            | bir minutdan kam dan keyin |
| 2000-01-01T00:00:15.000Z | bir minutdan kam | 20 sekunddan kam       | bir minutdan kam dan keyin |
| 2000-01-01T00:00:05.000Z | bir minutdan kam | 10 sekunddan kam       | bir minutdan kam dan keyin |
| 2000-01-01T00:00:00.000Z | bir minutdan kam | 5 sekunddan kam        | bir minutdan kam oldin     |
| 1999-12-31T23:59:55.000Z | bir minutdan kam | 10 sekunddan kam       | bir minutdan kam oldin     |
| 1999-12-31T23:59:45.000Z | bir minutdan kam | 20 sekunddan kam       | bir minutdan kam oldin     |
| 1999-12-31T23:59:35.000Z | bir minutdan kam | yarim minut            | bir minutdan kam oldin     |
| 1999-12-31T23:59:00.000Z | 1 minut          | 1 minut                | 1 minut oldin              |
| 1999-12-31T23:45:00.000Z | 15 minut         | 15 minut               | 15 minut oldin             |
| 1999-12-31T23:30:00.000Z | 30 minut         | 30 minut               | 30 minut oldin             |
| 1999-12-31T23:15:00.000Z | tahminan 1 soat  | tahminan 1 soat        | tahminan 1 soat oldin      |
| 1999-12-31T23:00:00.000Z | tahminan 1 soat  | tahminan 1 soat        | tahminan 1 soat oldin      |
| 1999-12-31T18:00:00.000Z | tahminan 6 soat  | tahminan 6 soat        | tahminan 6 soat oldin      |
| 1999-12-30T00:00:00.000Z | 2 kun            | 2 kun                  | 2 kun oldin                |
| 1999-12-15T00:00:00.000Z | 17 kun           | 17 kun                 | 17 kun oldin               |
| 1999-12-01T00:00:00.000Z | tahminan 1 oy    | tahminan 1 oy          | tahminan 1 oy oldin        |
| 1999-11-01T00:00:00.000Z | 2 oy             | 2 oy                   | 2 oy oldin                 |
| 1999-06-01T00:00:00.000Z | 7 oy             | 7 oy                   | 7 oy oldin                 |
| 1999-01-01T00:00:00.000Z | tahminan 1 yil   | tahminan 1 yil         | tahminan 1 yil oldin       |
| 1998-12-01T00:00:00.000Z | tahminan 1 yil   | tahminan 1 yil         | tahminan 1 yil oldin       |
| 1998-06-01T00:00:00.000Z | 1 yildan ko'p    | 1 yildan ko'p          | 1 yildan ko'p oldin        |
| 1998-01-01T00:00:00.000Z | tahminan 2 yil   | tahminan 2 yil         | tahminan 2 yil oldin       |
| 1997-01-01T00:00:00.000Z | tahminan 3 yil   | tahminan 3 yil         | tahminan 3 yil oldin       |
| 1996-01-01T00:00:00.000Z | tahminan 4 yil   | tahminan 4 yil         | tahminan 4 yil oldin       |
| 1995-01-01T00:00:00.000Z | tahminan 5 yil   | tahminan 5 yil         | tahminan 5 yil oldin       |
| 1994-01-01T00:00:00.000Z | tahminan 6 yil   | tahminan 6 yil         | tahminan 6 yil oldin       |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true`   | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 yil     | 6 yil dan keyin     | 52608 soat                     |
| 2005-01-01T00:00:00.000Z | 5 yil     | 5 yil dan keyin     | 43848 soat                     |
| 2004-01-01T00:00:00.000Z | 4 yil     | 4 yil dan keyin     | 35064 soat                     |
| 2003-01-01T00:00:00.000Z | 3 yil     | 3 yil dan keyin     | 26304 soat                     |
| 2002-01-01T00:00:00.000Z | 2 yil     | 2 yil dan keyin     | 17544 soat                     |
| 2001-06-01T00:00:00.000Z | 1 yil     | 1 yil dan keyin     | 12408 soat                     |
| 2001-02-01T00:00:00.000Z | 1 yil     | 1 yil dan keyin     | 9528 soat                      |
| 2001-01-01T00:00:00.000Z | 1 yil     | 1 yil dan keyin     | 8784 soat                      |
| 2000-06-01T00:00:00.000Z | 5 oy      | 5 oy dan keyin      | 3648 soat                      |
| 2000-03-01T00:00:00.000Z | 2 oy      | 2 oy dan keyin      | 1440 soat                      |
| 2000-02-01T00:00:00.000Z | 1 oy      | 1 oy dan keyin      | 744 soat                       |
| 2000-01-15T00:00:00.000Z | 14 kun    | 14 kun dan keyin    | 336 soat                       |
| 2000-01-02T00:00:00.000Z | 1 kun     | 1 kun dan keyin     | 24 soat                        |
| 2000-01-01T06:00:00.000Z | 6 soat    | 6 soat dan keyin    | 6 soat                         |
| 2000-01-01T01:00:00.000Z | 1 soat    | 1 soat dan keyin    | 1 soat                         |
| 2000-01-01T00:45:00.000Z | 45 minut  | 45 minut dan keyin  | 1 soat                         |
| 2000-01-01T00:30:00.000Z | 30 minut  | 30 minut dan keyin  | 1 soat                         |
| 2000-01-01T00:15:00.000Z | 15 minut  | 15 minut dan keyin  | 0 soat                         |
| 2000-01-01T00:01:00.000Z | 1 minut   | 1 minut dan keyin   | 0 soat                         |
| 2000-01-01T00:00:25.000Z | 25 sekund | 25 sekund dan keyin | 0 soat                         |
| 2000-01-01T00:00:15.000Z | 15 sekund | 15 sekund dan keyin | 0 soat                         |
| 2000-01-01T00:00:05.000Z | 5 sekund  | 5 sekund dan keyin  | 0 soat                         |
| 2000-01-01T00:00:00.000Z | 0 sekund  | 0 sekund oldin      | 0 soat                         |
| 1999-12-31T23:59:55.000Z | 5 sekund  | 5 sekund oldin      | 0 soat                         |
| 1999-12-31T23:59:45.000Z | 15 sekund | 15 sekund oldin     | 0 soat                         |
| 1999-12-31T23:59:35.000Z | 25 sekund | 25 sekund oldin     | 0 soat                         |
| 1999-12-31T23:59:00.000Z | 1 minut   | 1 minut oldin       | 0 soat                         |
| 1999-12-31T23:45:00.000Z | 15 minut  | 15 minut oldin      | 0 soat                         |
| 1999-12-31T23:30:00.000Z | 30 minut  | 30 minut oldin      | 1 soat                         |
| 1999-12-31T23:15:00.000Z | 45 minut  | 45 minut oldin      | 1 soat                         |
| 1999-12-31T23:00:00.000Z | 1 soat    | 1 soat oldin        | 1 soat                         |
| 1999-12-31T18:00:00.000Z | 6 soat    | 6 soat oldin        | 6 soat                         |
| 1999-12-30T00:00:00.000Z | 2 kun     | 2 kun oldin         | 48 soat                        |
| 1999-12-15T00:00:00.000Z | 17 kun    | 17 kun oldin        | 408 soat                       |
| 1999-12-01T00:00:00.000Z | 1 oy      | 1 oy oldin          | 744 soat                       |
| 1999-11-01T00:00:00.000Z | 2 oy      | 2 oy oldin          | 1464 soat                      |
| 1999-06-01T00:00:00.000Z | 7 oy      | 7 oy oldin          | 5136 soat                      |
| 1999-01-01T00:00:00.000Z | 1 yil     | 1 yil oldin         | 8760 soat                      |
| 1998-12-01T00:00:00.000Z | 1 yil     | 1 yil oldin         | 9504 soat                      |
| 1998-06-01T00:00:00.000Z | 2 yil     | 2 yil oldin         | 13896 soat                     |
| 1998-01-01T00:00:00.000Z | 2 yil     | 2 yil oldin         | 17520 soat                     |
| 1997-01-01T00:00:00.000Z | 3 yil     | 3 yil oldin         | 26280 soat                     |
| 1996-01-01T00:00:00.000Z | 4 yil     | 4 yil oldin         | 35064 soat                     |
| 1995-01-01T00:00:00.000Z | 5 yil     | 5 yil oldin         | 43824 soat                     |
| 1994-01-01T00:00:00.000Z | 6 yil     | 6 yil oldin         | 52584 soat                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                    |
| ------------------------ | ------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                |
| 2000-01-05T00:00:00.000Z | Chorshanba 12:00 da       |
| 2000-01-02T00:00:00.000Z | ertaga 12:00 da           |
| 2000-01-01T00:00:00.000Z | bugun 12:00 da            |
| 1999-12-31T00:00:00.000Z | kecha 12:00 da            |
| 1999-12-27T00:00:00.000Z | oldingi Dushanba 12:00 da |
| 1999-12-21T00:00:00.000Z | 21/12/1999                |
