/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_product_group.h
 * @brief implementation of the update_product_group function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_UPDATE_PRODUCT_GROUP_H
#define PG_UPDATE_PRODUCT_GROUP_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Update details about a particular product group.
 *
 * @param cls closure
 * @param instance_id instance to update product group for
 * @param product_group_id serial number of the group to update
 * @param name set to name of the group
 * @param description set to description of the group
 * @param[out] conflict set to true if @a name is already used
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_update_product_group (
  void *cls,
  const char *instance_id,
  uint64_t product_group_id,
  const char *name,
  const char *description,
  bool *conflict);


#endif
